package editor;

public abstract class MobileScreenPaletteObject extends ScreenPaletteObject {
	
	public static final int DEFAULT = 0;
	public static final int SETTING_MIN = 1;
	public static final int SETTING_MAX = 2;
	
	protected int mode = 0;
	protected boolean settingFromSelector = false;
	
	private MobileScreenObject constructedObject;
	

	public void setMode(int newMode) {
		mode = newMode;
	}
	public int getMode() {
		return mode;
	}
	
	public void setConstructedObject(MobileScreenObject newConsObj) {
		constructedObject = newConsObj;
		if(constructedObject != null)
			constructedObject.setPaletteObject(this);
	}
	
	public MobileScreenObject getConstructedObject() {
		return constructedObject;
	}
	
	public void setSelected(boolean is) {
		super.setSelected(is);
		if(!is) {
			setMode(DEFAULT);
		}
	}
	public boolean isSettingFromSelector() {
		return settingFromSelector;
	}
	public void setSettingFromSelector(boolean settingFromSelector) {
		this.settingFromSelector = settingFromSelector;
	}
	
	
	
}
